/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   This tutorial is using PhysX, to run it, you must:
      -have PhysX SystemSoftware installed from http://www.nvidia.com/content/drivers/drivers.asp
      -have "NxCooking.dll" in your application folder

/******************************************************************************/
Actor ground,
      box   ,
      ball  ;
/******************************************************************************/
void InitPre()
{
   App.name="Physics";
   App.flag=APP_MS_EXCLUSIVE|APP_NO_FX;
   PakAdd("../data/engine.pak");
   D.sync(true);
}
Bool Init()
{
   Cam.dist=4;

   // create physics
   Physics.create();

   // create actors
   ground.create(Box (15,1,15,Vec(0  ,-2, 0)), 0); // create ground actor from Box and density=0 (which means it's a static actor - will not move)
   box   .create(Box (0.3    ,Vec(0.1, 1, 0)));
   ball  .create(Ball(0.3    ,Vec(  0, 0, 0)));

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|CAMH_ROT);

   // physics update
   {
      Physics.sim(); // start frame simulation

      // physics simulation takes some time, so you can do some calculations here
      // important : you may not modify actors between Physics.sim() and Physics.get()

      Physics.get(); // get results of frame simulation
   }

   Flt s=3;

   // add forces to ball
   if(Kb.b(KB_UP   ))ball.addForce(Vec(0,0, 1)*s);
   if(Kb.b(KB_DOWN ))ball.addForce(Vec(0,0,-1)*s);
   if(Kb.b(KB_LEFT ))ball.addForce(Vec(-1,0,0)*s);
   if(Kb.b(KB_RIGHT))ball.addForce(Vec( 1,0,0)*s);

   // add forces to ball according to camera
   if(Kb.b(KB_W))ball.addForce( !PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s);
   if(Kb.b(KB_S))ball.addForce(-!PointOnPlane(Cam.matrix.z,Vec(0,1,0))*s);
   if(Kb.b(KB_A))ball.addForce(-!PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s);
   if(Kb.b(KB_D))ball.addForce( !PointOnPlane(Cam.matrix.x,Vec(0,1,0))*s);

   // add velocity to ball
   if(Kb.bp(KB_SPACE))ball.addVel(Vec(0,3,0));
   return true;
}
/******************************************************************************/
void Draw()
{
   D      .clear();
   Physics.draw (); // draw physical actors
}
/******************************************************************************/
